##########################################################################
# 21st October 2022
# XI CONGRESO IBÉRICO DE BALONCESTO
# IV Congreso Iberoamericano de baloncesto
#
# 7th November 2025
# Jornadas de Inteligencia Artificial para Analítica Deportiva
# Universidad de Castilla-La Mancha, Albacete
# 
# Paola Zuccolotto and Marica Manisera
###########################################################################


rm(list=ls())

# install BasketballAnalyzeR
install.packages("BasketballAnalyzeR")
library(BasketballAnalyzeR)

dir <- "C:/"   # set your working directory
setwd(dir)

############################################
############################################
# CHAPTER 2                                #
# Data and Basic Statistical Analyses      #
############################################
############################################
# Box scores EUROBASKET 2022
TboxE22 <- read.table(file="TboxEuro22.txt",header=T)

PTSO <- TboxE22$PTS - TboxE22$PM  		# points made by the opponents


######################
# 2.2 BASIC STATISTICAL ANALYSES
######################

######################
# 2.2.2 Bar-line plots
######################

X <- data.frame(Team=TboxE22$Team,PW=TboxE22$W/TboxE22$GP,
					P2M.M=TboxE22$P2M/TboxE22$MIN,
					P3M.M=TboxE22$P3M/TboxE22$MIN,
					FTM.M=TboxE22$FTM/TboxE22$MIN,
					PTSO.T=PTSO/TboxE22$PTS)
labs <- c("2P Made pm","3P Made pm","FT Made pm")
barline(data=X, id="Team", bars=c("P2M.M","P3M.M","FTM.M"),
		line="PTSO.T", order.by="PW", labels.bars=labs)
		

#####################
# 2.2.3 Radial plots
#####################

TboxE22.GP79 <- subset(TboxE22, GP == 7 | GP == 9)
PTSO.GP79 <- PTSO[TboxE22$GP == 7 | TboxE22$GP == 9]

attach(TboxE22.GP79)
X <- data.frame(P2M, P3M, FTM, REB=OREB+DREB, AST,
				STL, BLK,PTSO=PTSO.GP79)/MIN
detach(TboxE22.GP79)
dev.new(width=20, height=10)
gglst <- radialprofile(data=X, title=TboxE22.GP79$Team, std=TRUE, ncol.arrange=4, label.size=3) 


#####################
# 2.2.4 Scatter plots
#####################

# attach(TboxE22)
# X <- data.frame(AST, TOV, PTS)/MIN
# detach(TboxE22)
# mypal <- colorRampPalette(c("blue","yellow","red"))
# ES <- which(TboxE22$Team=="Spain")
# scatterplot(X, data.var=c("AST","TOV"), z.var="PTS",
# 			labels=TboxE22$Team, palette=mypal,subset=ES)
# scatterplot(X, data.var=c("AST","TOV"), z.var="PTS",
# 			labels=TboxE22$Team, palette=mypal)


attach(TboxE22)
X <- data.frame(PTS.M=PTS/MIN, PTSO.M=PTSO/MIN, PW=W/GP)
detach(TboxE22)
mypal <- colorRampPalette(c("blue","yellow","red"))
ES <- which(TboxE22$Team=="Spain")
dev.new()
scatterplot(X, data.var=c("PTS.M","PTSO.M"), z.var="PW",
			labels=TboxE22$Team, palette=mypal,subset=ES, label_size=5)
dev.new()
scatterplot(X, data.var=c("PTS.M","PTSO.M"), z.var="PW",
			labels=TboxE22$Team, palette=mypal, label_size=5)



#####################
# 2.2.5 Bubble plots
#####################

attach(TboxE22)
X <- data.frame(T=Team, P2p, P3p, FTp, AS=P2A+P3A+FTA)
detach(TboxE22)
labs <- c("2-point shots (% made)",
		  "3-point shots (% made)",
		  "free throws (% made)",
		  "Total shots attempted")
bubbleplot(X, id="T", x="P2p", y="P3p", col="FTp",
		   size="AS", labels=labs, text.size=4.5)


############################################
############################################
# CHAPTER 3                                #
# Discovering Patterns in Data             #
############################################
############################################

####################
# 3.3 DISPLAYING INDIVIDUAL CASES ACCORDING TO THEIR SIMILARITY
#####################
attach(TboxE22)
data <- data.frame(PTSO.T=PTSO/TboxE22$PTS, P3M.M=P3M/MIN, P2M.M=P2M/MIN, PW=W/GP)
detach(TboxE22)

id <- TboxE22$Team

mds <- MDSmap(data)
plot(mds, labels=id,label_size=5)

dev.new()
plot(mds, labels=id,,label_size=5,z.var=c("PTSO.T","P3M.M","P2M.M","PW"), level.plot=FALSE, palette=rainbow)

dev.new()
plot(mds, z.var=c("PTSO.T","P3M.M","P2M.M","PW"), contour=TRUE, palette=topo.colors)



############################################
############################################
# CHAPTER 4                                #
# Findings Groups in Data                  #
############################################
############################################

#####################
# 4.2.1 k-means clustering of teams
#####################

install.packages("sjmisc")
library(sjmisc)
GP_rec <- rec(TboxE22$GP, rec="5,6=1; 7,9=2", as.num=T, append=F, suffix="")

data <- data.frame(P2M.M=TboxE22$P2M/TboxE22$MIN,
					P3M.M=TboxE22$P3M/TboxE22$MIN,
					AST.M=TboxE22$AST/TboxE22$MIN,
					PTSO.T=PTSO/TboxE22$PTS,
					PW=TboxE22$W/TboxE22$GP)

graphics.off()
set.seed(7256793)
kclu1 <- kclustering(data)
plot(kclu1)

set.seed(7256793)
kclu2 <- kclustering(data, labels=TboxE22$Team, k=4)
plot(kclu2,label.size=4)
kclu2


kclu2.GP <- table(kclu2$Subjects$Cluster, GP_rec)
kclu2.W <- tapply(TboxE22$W, kclu2$Subjects$Cluster, mean)

Xbar <- data.frame(cluster=c(1:4), G56=kclu2.GP[,1],
				   G79=kclu2.GP[,2], W=kclu2.W)
dev.new()
barline(data=Xbar, id="cluster", bars=c("G56","G79"),
		labels.bars=c("5 or 6 games played","7 or 9 games played"),
		line="W", label.line="average wins",
		decreasing=FALSE)














